/*
 * Decompiled with CFR 0.152.
 */
import cds.aladin.AladinData;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;

public class BytePixelPlug
extends AladinPlugin {
    @Override
    public String menu() {
        return "Image dump & reverse";
    }

    @Override
    public String description() {
        return "PLUGIN TUTORIAL:\nThis plugin is an example for manipulating the byte pixel buffer.\nIt will create a copy of current plane image, and will reverseall pixels.\n\nThis plugin can be launched by script via the \"inverse\" command.";
    }

    @Override
    public String author() {
        return "Pierre Fernique [CDS]";
    }

    @Override
    public String version() {
        return "1.1 - January 2007";
    }

    @Override
    public String url() {
        return "http://aladin.u-strasbg.fr/java/Plugins/BytePixelPlug.java";
    }

    @Override
    public String category() {
        return "Plugin tutorial/Image";
    }

    @Override
    public String scriptCommand() {
        return "inverse";
    }

    @Override
    public void exec() {
        try {
            String labelImg = this.aladin.getAladinImage().getLabel();
            this.aladin.execCommand("copy " + labelImg + " copyOf" + labelImg);
            AladinData sd = this.aladin.getAladinData("copyOf" + labelImg);
            byte[] pix = sd.seeBytePixels();
            for (int i = 0; i < pix.length; ++i) {
                pix[i] = (byte)(~(0xFF & pix[i]));
            }
            sd.bytePixelsModified();
        }
        catch (AladinException e) {
            this.aladin.warning("Plugin error: " + e.getMessage());
        }
    }
}

